/*
 * Decompiled with CFR 0.152.
 */
package com.viafirma.fortress.sdk;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.viafirma.fortress.sdk.configuration.FortressApiConfiguration;
import com.viafirma.fortress.sdk.exception.ApiException;
import com.viafirma.fortress.sdk.exception.CertificateAlreadyExistsException;
import com.viafirma.fortress.sdk.exception.CertificateNotFoundException;
import com.viafirma.fortress.sdk.exception.CertificateValidationException;
import com.viafirma.fortress.sdk.exception.DocumentNotFoundException;
import com.viafirma.fortress.sdk.exception.ExpiredCertificateException;
import com.viafirma.fortress.sdk.exception.GroupNotFoundException;
import com.viafirma.fortress.sdk.exception.InvalidAliasException;
import com.viafirma.fortress.sdk.exception.InvalidAuthCacheException;
import com.viafirma.fortress.sdk.exception.InvalidCertificatePasswordException;
import com.viafirma.fortress.sdk.exception.InvalidClientException;
import com.viafirma.fortress.sdk.exception.InvalidGrantException;
import com.viafirma.fortress.sdk.exception.InvalidKeystoreException;
import com.viafirma.fortress.sdk.exception.InvalidLicenseException;
import com.viafirma.fortress.sdk.exception.InvalidRequestException;
import com.viafirma.fortress.sdk.exception.InvalidResponseException;
import com.viafirma.fortress.sdk.exception.InvalidTokenException;
import com.viafirma.fortress.sdk.exception.InvalidUserException;
import com.viafirma.fortress.sdk.exception.LockedCertificateException;
import com.viafirma.fortress.sdk.exception.NetworkException;
import com.viafirma.fortress.sdk.exception.NotAuthorizedSignatureException;
import com.viafirma.fortress.sdk.exception.NotTrustedCertificateException;
import com.viafirma.fortress.sdk.exception.RedirectUriMismatchException;
import com.viafirma.fortress.sdk.exception.RevokedCertificateException;
import com.viafirma.fortress.sdk.exception.SecurityException;
import com.viafirma.fortress.sdk.exception.SendEmailException;
import com.viafirma.fortress.sdk.exception.ServerException;
import com.viafirma.fortress.sdk.exception.SignatureException;
import com.viafirma.fortress.sdk.exception.UserNotEnrolledException;
import com.viafirma.fortress.sdk.exception.UserNotFoundException;
import com.viafirma.fortress.sdk.model.AccessToken;
import com.viafirma.fortress.sdk.model.ApiError;
import com.viafirma.fortress.sdk.model.Certificate;
import com.viafirma.fortress.sdk.model.User;
import com.viafirma.fortress.sdk.model.UserStatus;
import com.viafirma.fortress.sdk.model.encryption.EncryptRequest;
import com.viafirma.fortress.sdk.model.encryption.EncryptResponse;
import com.viafirma.fortress.sdk.model.signature.AuthorizeSignatureRequest;
import com.viafirma.fortress.sdk.model.signature.Document;
import com.viafirma.fortress.sdk.model.signature.ExecuteRequest;
import com.viafirma.fortress.sdk.model.signature.ExtendSignatureRequest;
import com.viafirma.fortress.sdk.model.signature.ExtendSignatureResponse;
import com.viafirma.fortress.sdk.model.signature.SignatureRequest;
import com.viafirma.fortress.sdk.model.signature.SignatureRequestResponse;
import com.viafirma.fortress.sdk.model.signature.SignatureRequestStatus;
import com.viafirma.fortress.sdk.model.signature.SignatureResponse;
import com.viafirma.fortress.sdk.service.FortressApiService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class FortressApi {
    public static final String SCOPE_PROFILE = "profile";
    public static final String SCOPE_CLIENT = "client";
    public static final String SCOPE_SIGNATURE = "signature";
    public static final String SCOPE_CERTIFICATE = "certificate";
    public static final String SCOPE_CERTIFICATES = "certificates";
    public static final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    public static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private static final String RESPONSE_TYPE_CODE = "code";
    private static final String BEARER_PREFIX = "Bearer ";
    private final FortressApiService fortressApiService;
    private final FortressApiConfiguration fortressApiConfiguration;
    private static final OkHttpClient OK_HTTP_CLIENT = new OkHttpClient();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private static final Logger LOGGER = LoggerFactory.getLogger(FortressApi.class);

    public FortressApi(FortressApiConfiguration fortressApiConfiguration) {
        this(fortressApiConfiguration, OK_HTTP_CLIENT);
    }

    public FortressApi(FortressApiConfiguration fortressApiConfiguration, OkHttpClient okHttpClient) {
        this.fortressApiConfiguration = fortressApiConfiguration;
        String baseUrl = fortressApiConfiguration.getUrl();
        Retrofit retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OBJECT_MAPPER)).baseUrl(baseUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).client(this.getOkHttpClient(fortressApiConfiguration, okHttpClient)).build();
        this.fortressApiService = (FortressApiService)retrofit.create(FortressApiService.class);
    }

    private OkHttpClient getOkHttpClient(FortressApiConfiguration fortressApiConfiguration, OkHttpClient okHttpClient) {
        OkHttpClient.Builder builder = okHttpClient.newBuilder().connectTimeout(fortressApiConfiguration.getConnectionTimeout(), TimeUnit.SECONDS).readTimeout(fortressApiConfiguration.getReadTimeout(), TimeUnit.SECONDS);
        if (fortressApiConfiguration.isDebug()) {
            builder.addInterceptor((Interceptor)new HttpLoggingInterceptor(arg_0 -> ((Logger)LOGGER).debug(arg_0)).setLevel(HttpLoggingInterceptor.Level.BODY));
        }
        if (fortressApiConfiguration.isInsecure()) {
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            try {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
                builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
                builder.hostnameVerifier((hostname, session) -> true);
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException("Failed to init unsafe trust manager", e);
            }
        }
        return builder.build();
    }

    public FortressApiConfiguration getFortressApiConfiguration() {
        return this.fortressApiConfiguration;
    }

    public String getAuthorizationUri(String redirectUri, String userCode, String scope, String state) throws ApiException {
        String url = StringUtils.isNotBlank((CharSequence)this.fortressApiConfiguration.getPublicUrl()) ? this.fortressApiConfiguration.getPublicUrl() : this.fortressApiConfiguration.getUrl();
        StringBuilder uri = new StringBuilder();
        uri.append(url);
        uri.append("oauth2/v1/auth");
        uri.append("?client_id=").append(this.fortressApiConfiguration.getClientId());
        if (StringUtils.isNotBlank((CharSequence)userCode)) {
            uri.append("&user_code=").append(userCode);
        }
        uri.append("&scope=").append(scope);
        uri.append("&response_type=code");
        try {
            uri.append("&redirect_uri=").append(URLEncoder.encode(redirectUri, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            uri.append("&state=").append(state);
        }
        return uri.toString();
    }

    public String getAuthorizationUri(String redirectUri, String userCode, String scope) throws ApiException {
        return this.getAuthorizationUri(redirectUri, userCode, scope, null);
    }

    public String getAuthorizationUri(String userCode, String scope) throws ApiException {
        return this.getAuthorizationUri(this.fortressApiConfiguration.getRedirectUri(), userCode, scope, null);
    }

    public String getSignatureAuthorizationUri(String signatureCode, String redirectUri) throws ApiException {
        String url = StringUtils.isNotBlank((CharSequence)this.fortressApiConfiguration.getPublicUrl()) ? this.fortressApiConfiguration.getPublicUrl() : this.fortressApiConfiguration.getUrl();
        StringBuilder uri = new StringBuilder();
        uri.append(url);
        uri.append("oauth2/v1/auth");
        uri.append("?signature_code=").append(signatureCode);
        uri.append("&scope=").append(SCOPE_SIGNATURE);
        uri.append("&client_id=").append(this.fortressApiConfiguration.getClientId());
        try {
            uri.append("&redirect_uri=").append(URLEncoder.encode(redirectUri, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        return uri.toString();
    }

    public String getSignatureAuthorizationUri(String signatureCode) throws ApiException {
        return this.getSignatureAuthorizationUri(signatureCode, this.getFortressApiConfiguration().getRedirectUri());
    }

    public AccessToken getAccessToken(String code, String redirectUri, String grantType) throws ApiException {
        return this.getAccessToken(code, redirectUri, grantType, false);
    }

    public AccessToken getAccessToken(String code, String redirectUri, String grantType, boolean pem) throws ApiException {
        return this.executeCall(this.fortressApiService.getAccessToken(code, this.fortressApiConfiguration.getClientId(), this.fortressApiConfiguration.getClientSecret(), redirectUri, grantType, pem));
    }

    public AccessToken getUserAccessToken(String code) throws ApiException {
        return this.getUserAccessToken(code, false);
    }

    public AccessToken getUserAccessToken(String code, boolean pem) throws ApiException {
        return this.getAccessToken(code, this.fortressApiConfiguration.getRedirectUri(), GRANT_TYPE_AUTHORIZATION_CODE, pem);
    }

    public AccessToken getClientAccessToken() throws ApiException {
        return this.getAccessToken("", this.fortressApiConfiguration.getRedirectUri(), GRANT_TYPE_CLIENT_CREDENTIALS, false);
    }

    public List<Certificate> getClientCertificates(String accessToken) throws ApiException {
        return this.getClientCertificates(accessToken, true);
    }

    public List<Certificate> getClientCertificates(String accessToken, boolean pem) throws ApiException {
        return this.executeCall(this.fortressApiService.getClientCertificates(BEARER_PREFIX + accessToken, this.fortressApiConfiguration.getClientId(), pem));
    }

    public Certificate getClientCertificate(String accessToken, String certificateCode) throws ApiException {
        return this.getClientCertificate(accessToken, certificateCode, true);
    }

    public Certificate getClientCertificate(String accessToken, String certificateCode, boolean pem) throws ApiException {
        return this.executeCall(this.fortressApiService.getClientCertificate(BEARER_PREFIX + accessToken, this.fortressApiConfiguration.getClientId(), certificateCode, pem));
    }

    public UserStatus getUserStatus(String accessToken, String userCode) throws ApiException {
        return this.executeCall(this.fortressApiService.getUserStatus(BEARER_PREFIX + accessToken, userCode));
    }

    public User getUser(String accessToken, String userCode) throws ApiException {
        return this.executeCall(this.fortressApiService.getUser(BEARER_PREFIX + accessToken, userCode));
    }

    public List<Certificate> getCertificates(String accessToken, String userCode) throws ApiException {
        return this.getCertificates(accessToken, userCode, true);
    }

    public List<Certificate> getCertificates(String accessToken, String userCode, boolean pem) throws ApiException {
        return this.executeCall(this.fortressApiService.getCertificates(BEARER_PREFIX + accessToken, userCode, pem));
    }

    public Certificate getCertificate(String accessToken, String userCode, String certificateCode) throws ApiException {
        return this.getCertificate(accessToken, userCode, certificateCode, true);
    }

    public Certificate getCertificate(String accessToken, String userCode, String certificateCode, boolean pem) throws ApiException {
        return this.executeCall(this.fortressApiService.getCertificate(BEARER_PREFIX + accessToken, userCode, certificateCode, pem));
    }

    public SignatureRequestResponse signatureRequest(String accessToken, SignatureRequest signatureRequest) throws ApiException {
        return this.executeCall(this.fortressApiService.requestSignature(BEARER_PREFIX + accessToken, signatureRequest));
    }

    public SignatureRequestStatus getSignatureRequestStatus(String accessToken, String authCode) throws ApiException {
        return this.executeCall(this.fortressApiService.getSignatureRequestStatus(BEARER_PREFIX + accessToken, authCode));
    }

    public List<SignatureResponse> executeSignature(String accessToken, String executionCode) throws ApiException {
        return this.executeSignature(accessToken, executionCode, false, false, new ExecuteRequest());
    }

    public List<SignatureResponse> executeSignature(String accessToken, String executionCode, ExecuteRequest executeRequest) throws ApiException {
        return this.executeSignature(accessToken, executionCode, false, false, executeRequest);
    }

    public List<SignatureResponse> executeSignature(String accessToken, String executionCode, boolean pem) throws ApiException {
        return this.executeSignature(accessToken, executionCode, false, pem, new ExecuteRequest());
    }

    public List<SignatureResponse> executeSignature(String accessToken, String executionCode, boolean pem, ExecuteRequest executeRequest) throws ApiException {
        return this.executeSignature(accessToken, executionCode, false, pem, executeRequest);
    }

    public List<SignatureResponse> executeSignature(String accessToken, String executionCode, boolean authCache, boolean pem, ExecuteRequest executeRequest) throws ApiException {
        return this.executeCall(this.fortressApiService.executeSignature(BEARER_PREFIX + accessToken, executionCode, authCache, pem, executeRequest));
    }

    public void authorizeSignature(String accessToken, String authCode, AuthorizeSignatureRequest authorizeSignatureRequest) throws ApiException {
        this.executeCall(this.fortressApiService.authorizeSignature(BEARER_PREFIX + accessToken, authCode, authorizeSignatureRequest));
    }

    public void removeAuthCache(String accessToken, String userCode) throws ApiException {
        this.executeCall(this.fortressApiService.removeAuthCache(BEARER_PREFIX + accessToken, userCode));
    }

    public Document getDocument(String accessToken, String signatureCode) throws ApiException {
        return this.executeCall(this.fortressApiService.getDocument(BEARER_PREFIX + accessToken, signatureCode));
    }

    public List<ExtendSignatureResponse> extendSignatureRequest(String accessToken, ExtendSignatureRequest extendSignatureRequest) throws ApiException {
        return this.executeCall(this.fortressApiService.requestExtendSignature(BEARER_PREFIX + accessToken, extendSignatureRequest));
    }

    public EncryptResponse encrypt(String accessToken, EncryptRequest encryptRequest) throws ApiException {
        return this.executeCall(this.fortressApiService.encrypt(BEARER_PREFIX + accessToken, encryptRequest));
    }

    public byte[] downloadDocument(String accessToken, String signatureCode) throws ApiException {
        try {
            return this.executeCall(this.fortressApiService.downloadDocument(BEARER_PREFIX + accessToken, signatureCode)).bytes();
        }
        catch (IOException e) {
            throw new ApiException("Failed to download document: " + signatureCode, e);
        }
    }

    private <T> T executeCall(Call<T> call) throws ApiException {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            throw this.getFortressApiException(response);
        }
        catch (IOException e) {
            throw new NetworkException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> ApiException getFortressApiException(Response<T> response) {
        int statusCode = response.code();
        String errorBodyString = "";
        try (ResponseBody errorBody = response.errorBody();){
            if (errorBody == null) {
                InvalidResponseException invalidResponseException = new InvalidResponseException("Empty response body. Status code: " + statusCode);
                return invalidResponseException;
            }
            errorBodyString = errorBody.string();
            ApiError apiError = (ApiError)OBJECT_MAPPER.readValue(errorBodyString, ApiError.class);
            String error = apiError.getError();
            String description = apiError.getErrorDescription();
            switch (error) {
                case "invalid_request": {
                    InvalidRequestException invalidRequestException = new InvalidRequestException(description);
                    return invalidRequestException;
                }
                case "invalid_client": {
                    InvalidClientException invalidClientException = new InvalidClientException(description);
                    return invalidClientException;
                }
                case "invalid_grant": {
                    InvalidGrantException invalidGrantException = new InvalidGrantException(description);
                    return invalidGrantException;
                }
                case "redirect_uri_mismatch": {
                    RedirectUriMismatchException redirectUriMismatchException = new RedirectUriMismatchException(description);
                    return redirectUriMismatchException;
                }
                case "invalid_token": {
                    InvalidTokenException invalidTokenException = new InvalidTokenException(description);
                    return invalidTokenException;
                }
                case "user_not_found": {
                    UserNotFoundException userNotFoundException = new UserNotFoundException(description);
                    return userNotFoundException;
                }
                case "group_not_found": {
                    GroupNotFoundException groupNotFoundException = new GroupNotFoundException(description);
                    return groupNotFoundException;
                }
                case "certificate_not_found": {
                    CertificateNotFoundException certificateNotFoundException = new CertificateNotFoundException(description);
                    return certificateNotFoundException;
                }
                case "expired_certificate": {
                    ExpiredCertificateException expiredCertificateException = new ExpiredCertificateException(description);
                    return expiredCertificateException;
                }
                case "not_trusted_certificate": {
                    NotTrustedCertificateException notTrustedCertificateException = new NotTrustedCertificateException(description);
                    return notTrustedCertificateException;
                }
                case "revoked_certificate": {
                    RevokedCertificateException revokedCertificateException = new RevokedCertificateException(description);
                    return revokedCertificateException;
                }
                case "invalid_alias": {
                    InvalidAliasException invalidAliasException = new InvalidAliasException(description);
                    return invalidAliasException;
                }
                case "certificate_validation": {
                    CertificateValidationException certificateValidationException = new CertificateValidationException(description);
                    return certificateValidationException;
                }
                case "certificate_already_exists": {
                    CertificateAlreadyExistsException certificateAlreadyExistsException = new CertificateAlreadyExistsException(description);
                    return certificateAlreadyExistsException;
                }
                case "invalid_keystore": {
                    InvalidKeystoreException invalidKeystoreException = new InvalidKeystoreException(description);
                    return invalidKeystoreException;
                }
                case "document_not_found": {
                    DocumentNotFoundException documentNotFoundException = new DocumentNotFoundException(description);
                    return documentNotFoundException;
                }
                case "signature_error": {
                    SignatureException signatureException = new SignatureException(description);
                    return signatureException;
                }
                case "security_error": {
                    SecurityException securityException = new SecurityException(description);
                    return securityException;
                }
                case "invalid_license": {
                    InvalidLicenseException invalidLicenseException = new InvalidLicenseException(description);
                    return invalidLicenseException;
                }
                case "server_error": {
                    ServerException serverException = new ServerException(description);
                    return serverException;
                }
                case "network_error": {
                    NetworkException networkException = new NetworkException(description);
                    return networkException;
                }
                case "user_not_enroled": {
                    UserNotEnrolledException userNotEnrolledException = new UserNotEnrolledException(description);
                    return userNotEnrolledException;
                }
                case "not_authorized_signature": {
                    NotAuthorizedSignatureException notAuthorizedSignatureException = new NotAuthorizedSignatureException(description);
                    return notAuthorizedSignatureException;
                }
                case "invalid_user": {
                    InvalidUserException invalidUserException = new InvalidUserException(description);
                    return invalidUserException;
                }
                case "invalid_certificate_password": {
                    InvalidCertificatePasswordException invalidCertificatePasswordException = new InvalidCertificatePasswordException(description);
                    return invalidCertificatePasswordException;
                }
                case "locked_certificate": {
                    LockedCertificateException lockedCertificateException = new LockedCertificateException(description);
                    return lockedCertificateException;
                }
                case "send_email_error": {
                    SendEmailException sendEmailException = new SendEmailException(description);
                    return sendEmailException;
                }
                case "invalid_auth_cache": {
                    InvalidAuthCacheException invalidAuthCacheException = new InvalidAuthCacheException(description);
                    return invalidAuthCacheException;
                }
            }
            ApiException apiException = new ApiException("status: " + response.code() + (StringUtils.isNotEmpty((CharSequence)error) ? error : description));
            return apiException;
        }
        catch (IOException e) {
            LOGGER.info("ResponseBody: {}", (Object)errorBodyString);
            return new InvalidResponseException("Invalid response. Status code: " + statusCode, e);
        }
    }
}

