/*
 * Decompiled with CFR 0.152.
 */
package com.viafirma.fortress.sdk.configuration;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class FortressApiConfiguration {
    private static final long DEFAULT_CONNECTION_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    private static final long DEFAULT_READ_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    private String url;
    private String publicUrl;
    private String clientId;
    private String clientSecret;
    private boolean debug;
    private String redirectUri;
    private boolean insecure;
    private long connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private long readTimeout = DEFAULT_READ_TIMEOUT;

    public FortressApiConfiguration() {
    }

    public FortressApiConfiguration(String url, String clientId, String clientSecret) {
        this.url = url;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public FortressApiConfiguration(String url, String publicUrl, String redirectUri, String clientId, String clientSecret) {
        this(url, clientId, clientSecret);
        this.publicUrl = publicUrl;
        this.redirectUri = redirectUri;
    }

    public FortressApiConfiguration(String url, String redirectUri, String clientId, String clientSecret) {
        this(url, clientId, clientSecret);
        this.redirectUri = redirectUri;
    }

    public String getUrl() {
        if (StringUtils.isNotBlank((CharSequence)this.url) && !this.url.endsWith("/")) {
            return this.url + "/";
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPublicUrl() {
        if (StringUtils.isNotBlank((CharSequence)this.publicUrl) && !this.publicUrl.endsWith("/")) {
            return this.publicUrl + "/";
        }
        return this.publicUrl;
    }

    public void setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    public void setInsecure(boolean insecure) {
        this.insecure = insecure;
    }
}

