/*
 * Decompiled with CFR 0.152.
 */
package com.viafirma.fortress.sdk.model.signature;

public class Tsa {
    private Type type;
    private String url;
    private String user;
    private String password;
    private String certificateCode;
    private TimestampAlgorithm timestampAlgorithm = TimestampAlgorithm.SHA256;

    public Tsa() {
    }

    public Tsa(String url) {
        this.url = url;
        this.type = Type.URL;
    }

    public Tsa(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.type = Type.USER;
    }

    public Tsa(String url, String certificateCode, boolean tls) {
        this.url = url;
        this.certificateCode = certificateCode;
        this.type = tls ? Type.CERTIFICATE_TLS : Type.CERTIFICATE;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCertificateCode() {
        return this.certificateCode;
    }

    public void setCertificateCode(String certificateCode) {
        this.certificateCode = certificateCode;
    }

    public TimestampAlgorithm getTimestampAlgorithm() {
        return this.timestampAlgorithm;
    }

    public void setTimestampAlgorithm(TimestampAlgorithm timestampAlgorithm) {
        this.timestampAlgorithm = timestampAlgorithm;
    }

    public static enum TimestampAlgorithm {
        SHA1,
        SHA224,
        SHA256,
        SHA384,
        SHA512,
        RIPEMD160,
        MD2,
        MD5;

    }

    public static enum Type {
        URL,
        USER,
        CERTIFICATE,
        CERTIFICATE_TLS;

    }
}

