/*
 * Decompiled with CFR 0.152.
 */
package com.viafirma.fortress.sdk.service;

import com.viafirma.fortress.sdk.model.AccessToken;
import com.viafirma.fortress.sdk.model.Certificate;
import com.viafirma.fortress.sdk.model.User;
import com.viafirma.fortress.sdk.model.UserStatus;
import com.viafirma.fortress.sdk.model.encryption.EncryptRequest;
import com.viafirma.fortress.sdk.model.encryption.EncryptResponse;
import com.viafirma.fortress.sdk.model.signature.AuthorizeSignatureRequest;
import com.viafirma.fortress.sdk.model.signature.Document;
import com.viafirma.fortress.sdk.model.signature.ExecuteRequest;
import com.viafirma.fortress.sdk.model.signature.ExtendSignatureRequest;
import com.viafirma.fortress.sdk.model.signature.ExtendSignatureResponse;
import com.viafirma.fortress.sdk.model.signature.SignatureRequest;
import com.viafirma.fortress.sdk.model.signature.SignatureRequestResponse;
import com.viafirma.fortress.sdk.model.signature.SignatureRequestStatus;
import com.viafirma.fortress.sdk.model.signature.SignatureResponse;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface FortressApiService {
    @POST(value="oauth2/v1/token")
    @FormUrlEncoded
    public Call<AccessToken> getAccessToken(@Field(value="code") String var1, @Field(value="client_id") String var2, @Field(value="client_secret") String var3, @Field(value="redirect_uri") String var4, @Field(value="grant_type") String var5, @Field(value="pem") boolean var6);

    @GET(value="api/v1/client/{clientId}/certificate")
    public Call<List<Certificate>> getClientCertificates(@Header(value="Authorization") String var1, @Path(value="clientId") String var2, @Query(value="pem") boolean var3);

    @GET(value="api/v1/client/{clientId}/certificate/{certificateCode}")
    public Call<Certificate> getClientCertificate(@Header(value="Authorization") String var1, @Path(value="clientId") String var2, @Path(value="certificateCode") String var3, @Query(value="pem") boolean var4);

    @GET(value="api/v1/user/{userCode}/status")
    public Call<UserStatus> getUserStatus(@Header(value="Authorization") String var1, @Path(value="userCode") String var2);

    @GET(value="api/v1/user/{userCode}")
    public Call<User> getUser(@Header(value="Authorization") String var1, @Path(value="userCode") String var2);

    @GET(value="api/v1/user/{userCode}/certificate/{certificateCode}")
    public Call<Certificate> getCertificate(@Header(value="Authorization") String var1, @Path(value="userCode") String var2, @Path(value="certificateCode") String var3, @Query(value="pem") boolean var4);

    @GET(value="api/v1/user/{userCode}/certificate")
    public Call<List<Certificate>> getCertificates(@Header(value="Authorization") String var1, @Path(value="userCode") String var2, @Query(value="pem") boolean var3);

    @DELETE(value="api/v1/user/{userCode}/removeAuthCache")
    public Call<Void> removeAuthCache(@Header(value="Authorization") String var1, @Path(value="userCode") String var2);

    @POST(value="api/v1/signature")
    public Call<SignatureRequestResponse> requestSignature(@Header(value="Authorization") String var1, @Body SignatureRequest var2);

    @POST(value="api/v1/signature/{executionCode}/execute")
    public Call<List<SignatureResponse>> executeSignature(@Header(value="Authorization") String var1, @Path(value="executionCode") String var2, @Query(value="authCache") boolean var3, @Query(value="pem") boolean var4, @Body ExecuteRequest var5);

    @POST(value="api/v1/signature/{authCode}/authorize")
    public Call<Void> authorizeSignature(@Header(value="Authorization") String var1, @Path(value="authCode") String var2, @Body AuthorizeSignatureRequest var3);

    @GET(value="api/v1/signature/{authCode}/status")
    public Call<SignatureRequestStatus> getSignatureRequestStatus(@Header(value="Authorization") String var1, @Path(value="authCode") String var2);

    @GET(value="api/v1/signature/{signatureCode}")
    public Call<Document> getDocument(@Header(value="Authorization") String var1, @Path(value="signatureCode") String var2);

    @GET(value="api/v1/signature/download/{signatureCode}")
    public Call<ResponseBody> downloadDocument(@Header(value="Authorization") String var1, @Path(value="signatureCode") String var2);

    @POST(value="api/v1/signature/extend")
    public Call<List<ExtendSignatureResponse>> requestExtendSignature(@Header(value="Authorization") String var1, @Body ExtendSignatureRequest var2);

    @POST(value="api/v1/encrypt")
    public Call<EncryptResponse> encrypt(@Header(value="Authorization") String var1, @Body EncryptRequest var2);
}

